using System;
using System.Collections.Generic;

class Program
{
    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        List<int>[] rooms = new List<int>[n + 1];

        for (int i = 1; i <= n; i++)
        {
            rooms[i] = new List<int>();
        }

        for (int i = 1; i <= n-1 ; i++)
        {
            int[] uv = Array.ConvertAll(Console.ReadLine().Split(), int.Parse);
            rooms[uv[0]].Add(uv[1]);
            rooms[uv[1]].Add(uv[0]);
        }

        int[] platforms = Array.ConvertAll(Console.ReadLine().Split(), int.Parse);
        int[] changes = Array.ConvertAll(Console.ReadLine().Split(), int.Parse);

        int[] result = MinimumJumps(n, rooms, platforms, changes);

        for (int i = 0; i < n; i++)
        {
            Console.Write(result[i] + " ");
        }
    }

    static int[] MinimumJumps(int n, List<int>[] rooms, int[] platforms, int[] changes)
    {
        int[] result = new int[n];
        result[0] = 1;
        Queue<int> queue = new Queue<int>();
        bool[] visited = new bool[n + 1];

        for (int i = 1; i <= n; i++)
        {
            if (platforms[i - 1] == 1)
            {
                queue.Enqueue(i);
                visited[i] = true;
            }
        }

        while (queue.Count > 0)
        {
            int currentRoom = queue.Dequeue();

            foreach (var adjacentRoom in rooms[currentRoom])
            {
                if (!visited[adjacentRoom])
                {
                    visited[adjacentRoom] = true;
                    queue.Enqueue(adjacentRoom);

                    if (changes[adjacentRoom - 1] == 1)
                    {
                        platforms[adjacentRoom - 1] = 1 - platforms[adjacentRoom - 1];
                    }
                }
            }
        }

        for (int i = 1; i < n; i++)
        {
            if (platforms[i] == 0)
            {
                result[i] = -1;
            }
            else
            {
                int currentRoom = i + 1;
                int jumps = 0;

                while (currentRoom != 1)
                {
                    if (changes[currentRoom - 2] == 1)
                    {
                        platforms[currentRoom - 1] = 1 - platforms[currentRoom - 1];
                    }

                    currentRoom = rooms[currentRoom][0];
                    jumps++;
                }                
                result[i] = jumps;
            }
            
        }

        return result;
    }
}